# Herzog Dupont Elements for YOOtheme Pro Joomla! Plugin

Herzog Dupont Elements for YOOtheme Pro is an extension for the [YOOtheme Pro page builder](https://yootheme.com/page-builder) which adds more elements to the element library.

Copyright (C) 2021-2025 Thomas Weidlich

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <https://www.gnu.org/licenses/>.

The Timeline element is based on the Grid element, Copyright (C) 2016-2025 YOOtheme GmbH. The Flipcard element is based on the Panel element, Copyright (C) 2016-2025 YOOtheme GmbH. The Slideshow Grid element is based on the Grid and Slideshow elements, Copyright (C) 2016-2025 YOOtheme GmbH.

## Description

This plugin adds more elements to the element library of the YOOtheme Pro page builder.

- Toggle Element: Display a button to hide content, switch between content or change its appearance. It's based on the UIkit Toggle component with all its options.
- Progress Element: Display your stats visually in an animated progress bar with a text label. It's based on the UIkit Progress component with all its options.
- Timeline Element: Display multiple panel elements in a vertical timeline. It has all the panel and card settings and many more style and layout options.
- Counter Element: Display your stats visually in an animated circular progress counter. Choose from many style and layout options.
- Flipcard Element: Display a panel element with a flipcard animation. It flips the panel on hover or click to reveal another panel with different content on the back side.
- Image Comparison Element: Quickly compare two images with a draggable slider showing a before-after effect. Choose from many image and slider icon options.
- Slideshow Grid Element: Display multiple Slideshows within one grid. Every grid item will contain its own Slideshow including navigations, animations and other features.
- Lottie Element: Display eye-catching and engaging Lottie animations. Choose from a variety of triggers.

## Installation

- download the latest release package from the [releases page](https://github.com/forrestkirby/herzogdupont-joomla/releases) (*Assets 🠖 Source code (zip) or Source code (tar.gz)*)
- install it via the Joomla! extensions manager
- access the YOOtheme Pro Page Builder, the custom elements should now be available
- you can select which elements should or should not be loaded in YOOtheme Pro at *Settings > Herzog Dupont*

## Issues

If you want to report an issue, please use the [Github issue tool](https://github.com/forrestkirby/herzogdupont-joomla/issues).

## Links

- [Demo](https://herzog-dupont.de/yootheme-pro)
- [Documentation](https://herzog-dupont.de/documentation/herzog-dupont-for-yootheme-pro)
- [Herzog Dupont for YOOtheme Pro WordPress Plugin](https://wordpress.org/plugins/herzog-dupont)
- [YOOtheme Pro Documentation](https://yootheme.com/support/yootheme-pro/joomla/introduction)
- [YOOtheme Support](https://yootheme.com/support)

## Screenshots

![](https://herzog-dupont.de/images/tutorials/tutorial-herzogdupont-1.jpg)

![](https://herzog-dupont.de/images/tutorials/tutorial-herzogdupont-2.jpg)
